import { Target, Shield, Zap } from "lucide-react";
import { Card, CardContent } from "@/components/ui/card";

const benefits = [
  {
    icon: Target,
    title: "Easy to Use",
    description: "Simply enter your reference details and lookup information instantly. No complicated steps or lengthy processes required.",
  },
  {
    icon: Shield,
    title: "Safe & Secure",
    description: "Your information is encrypted and protected with industry-standard security measures.",
  },
  {
    icon: Zap,
    title: "Fast Results",
    description: "Get your reference information and details in seconds, not minutes.",
  },
];

export function BenefitsSection() {
  return (
    <section className="py-16" data-testid="section-benefits">
      <div className="text-center mb-12">
        <h2 className="text-3xl sm:text-4xl font-extrabold text-foreground mb-3">
          Why Use Our Reference System?
        </h2>
        <p className="text-muted-foreground text-base sm:text-lg max-w-2xl mx-auto">
          Discover the benefits and convenience of our bonus and discount reference lookup system
        </p>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        {benefits.map((benefit, index) => (
          <Card 
            key={index} 
            className="hover:-translate-y-1 hover:shadow-lg transition-all duration-200 border-0 shadow-md"
            data-testid={`card-benefit-${index}`}
          >
            <CardContent className="p-8 text-center">
              <div className="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white">
                <benefit.icon className="w-8 h-8" />
              </div>
              <h3 className="text-xl font-bold text-primary mb-3">{benefit.title}</h3>
              <p className="text-muted-foreground leading-relaxed">{benefit.description}</p>
            </CardContent>
          </Card>
        ))}
      </div>
    </section>
  );
}
