import { Button } from "@/components/ui/button";

interface CTASectionProps {
  onCheckBalance: () => void;
}

export function CTASection({ onCheckBalance }: CTASectionProps) {
  return (
    <section 
      className="py-16 px-8 sm:px-12 bg-gradient-to-br from-blue-600 to-blue-700 rounded-3xl text-center text-white"
      data-testid="section-cta"
    >
      <h2 className="text-3xl sm:text-4xl font-extrabold mb-4">
        Ready to Lookup Your Reference?
      </h2>
      <p className="text-lg opacity-95 mb-8 max-w-xl mx-auto">
        Access your bonus and discount information quickly and easily!
      </p>
      <Button
        size="lg"
        variant="secondary"
        className="bg-white text-blue-600 hover:bg-blue-50 font-bold px-12 py-6 text-lg shadow-lg"
        onClick={onCheckBalance}
        data-testid="button-cta-check"
      >
        Lookup Reference Now
      </Button>
    </section>
  );
}
