import { Shield, Clock, Globe, Headphones } from "lucide-react";

const features = [
  {
    icon: Shield,
    title: "Enterprise-Level Security",
    description: "Your data is protected with 256-bit SSL encryption and secure servers.",
  },
  {
    icon: Clock,
    title: "24/7 Availability",
    description: "Access your reference information anytime, anywhere, from any device.",
  },
  {
    icon: Globe,
    title: "Multiple Categories",
    description: "Support for various bonus and discount reference categories.",
  },
  {
    icon: Headphones,
    title: "Customer Support",
    description: "Our dedicated team is here to help with any questions or issues.",
  },
];

export function FeaturesSection() {
  return (
    <section className="py-16" data-testid="section-features">
      <div className="text-center mb-12">
        <h2 className="text-3xl sm:text-4xl font-extrabold text-foreground mb-3">
          Why Trust Us
        </h2>
        <p className="text-muted-foreground text-base sm:text-lg max-w-2xl mx-auto">
          We provide a secure and reliable platform for all your reference lookup needs
        </p>
      </div>

      <div className="grid gap-6">
        {features.map((feature, index) => (
          <div 
            key={index} 
            className="flex flex-col sm:flex-row gap-5 items-start sm:items-center bg-card p-6 rounded-2xl shadow-sm hover:shadow-md transition-shadow"
            data-testid={`feature-${index}`}
          >
            <div className="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white flex-shrink-0">
              <feature.icon className="w-7 h-7" />
            </div>
            <div className="flex-1">
              <h3 className="text-lg font-bold text-foreground mb-2">{feature.title}</h3>
              <p className="text-muted-foreground leading-relaxed">{feature.description}</p>
            </div>
          </div>
        ))}
      </div>
    </section>
  );
}
