const steps = [
  {
    number: 1,
    title: "Enter Reference Details",
    description: "Fill in your reference number, date, and verification code.",
  },
  {
    number: 2,
    title: "Verify Information",
    description: "We securely verify your reference details with our system.",
  },
  {
    number: 3,
    title: "View Details",
    description: "See your bonus and discount information instantly.",
  },
];

export function HowItWorksSection() {
  return (
    <section className="py-16 px-6 sm:px-10 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-950/30 dark:to-blue-900/20 rounded-3xl" data-testid="section-how-it-works">
      <div className="text-center mb-12">
        <h2 className="text-3xl sm:text-4xl font-extrabold text-foreground mb-3">
          How It Works
        </h2>
        <p className="text-muted-foreground text-base sm:text-lg max-w-2xl mx-auto">
          Looking up your reference information is quick and easy
        </p>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
        {steps.map((step) => (
          <div key={step.number} className="text-center" data-testid={`step-${step.number}`}>
            <div className="w-16 h-16 mx-auto mb-5 bg-primary text-primary-foreground rounded-full flex items-center justify-center text-2xl font-extrabold">
              {step.number}
            </div>
            <h3 className="text-xl font-bold text-foreground mb-3">{step.title}</h3>
            <p className="text-muted-foreground leading-relaxed">{step.description}</p>
          </div>
        ))}
      </div>
    </section>
  );
}
