import { Link } from "wouter";

export function Header() {
  return (
    <header className="bg-card border-b border-border shadow-sm" data-testid="header">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between h-16">
          <div className="flex items-center gap-2">
            <Link href="/" className="text-xl font-bold text-primary tracking-tight" data-testid="link-logo">
              My Gift Info
            </Link>
          </div>
          <nav className="hidden md:flex items-center gap-8" data-testid="nav-main">
            <Link 
              href="/" 
              className="text-muted-foreground hover:text-primary font-medium transition-colors text-sm"
              data-testid="link-home"
            >
              Home
            </Link>
            <Link 
              href="/#guide" 
              className="text-muted-foreground hover:text-primary font-medium transition-colors text-sm"
              data-testid="link-guide"
            >
              Guide
            </Link>
            <Link 
              href="/#contact" 
              className="text-muted-foreground hover:text-primary font-medium transition-colors text-sm"
              data-testid="link-contact"
            >
              Contact
            </Link>
          </nav>
        </div>
      </div>
    </header>
  );
}
