import { Link } from "wouter";
import { ArrowLeft } from "lucide-react";
import { Header } from "@/components/layout/header";
import { Card, CardContent } from "@/components/ui/card";

export default function TermsOfService() {
  return (
    <div className="min-h-screen flex flex-col bg-background" data-testid="page-terms-of-service">
      <Header />
      
      <main className="flex-1">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
          <Link 
            href="/" 
            className="inline-flex items-center gap-2 text-primary font-semibold mb-6 hover:gap-3 transition-all"
            data-testid="link-back-home"
          >
            <ArrowLeft className="w-4 h-4" />
            Back to Home
          </Link>

          <div className="text-center mb-12">
            <h1 className="text-4xl sm:text-5xl font-extrabold text-foreground mb-3" data-testid="text-page-title">
              Terms of Service
            </h1>
            <p className="text-muted-foreground">Last updated: October 2025</p>
          </div>

          <Card className="shadow-lg border-0">
            <CardContent className="p-8 sm:p-10 space-y-8">
              <div className="bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-950/30 dark:to-blue-900/20 border-l-4 border-primary p-5 rounded-lg">
                <p className="text-foreground leading-relaxed">
                  <strong>Agreement to Terms:</strong> By accessing and using My Gift Info, you agree to be bound by these Terms of Service. Please read them carefully before using our service.
                </p>
              </div>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">1. Acceptance of Terms</h2>
                <p className="text-muted-foreground leading-relaxed">
                  By accessing or using the My Gift Info service, you acknowledge that you have read, understood, and agree to be bound by these Terms of Service and our Privacy Policy. If you do not agree to these terms, please do not use our service.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">2. Description of Service</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  My Gift Info provides a platform for users to check gift card balances and register gift cards. Our service allows you to:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Verify your gift card balance in real-time.</li>
                  <li>View transaction history associated with your gift cards.</li>
                  <li>Register and manage multiple gift cards from various brands.</li>
                  <li>Access your information securely from any device.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">3. User Responsibilities</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  When using our service, you agree to:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li><strong>Provide Accurate Information:</strong> Enter correct and up-to-date gift card details.</li>
                  <li><strong>Protect Your Information:</strong> Keep your gift card details confidential and secure.</li>
                  <li><strong>Legal Use:</strong> Use the service only for lawful purposes and in compliance with all applicable laws.</li>
                  <li><strong>No Unauthorized Access:</strong> Not attempt to gain unauthorized access to our systems or other users' accounts.</li>
                  <li><strong>Prohibited Activities:</strong> Not engage in any fraudulent, abusive, or harmful activities.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">4. Intellectual Property Rights</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  All content, features, and functionality of My Gift Info, including but not limited to text, graphics, logos, and software, are owned by us or our licensors and are protected by copyright, trademark, and other intellectual property laws.
                </p>
                <p className="text-muted-foreground mb-4 leading-relaxed">You may not:</p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Copy, modify, or distribute any content from our service without permission.</li>
                  <li>Use our trademarks or branding without written authorization.</li>
                  <li>Reverse engineer or attempt to extract source code from our platform.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">5. Limitation of Liability</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  To the fullest extent permitted by law:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>My Gift Info is provided "as is" without warranties of any kind, either express or implied.</li>
                  <li>We do not guarantee that the service will be uninterrupted, secure, or error-free.</li>
                  <li>We are not responsible for any losses or damages arising from your use of the service.</li>
                  <li>We are not liable for unauthorized access to or alteration of your data.</li>
                  <li>Our total liability shall not exceed the amount you paid for using the service.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">6. Third-Party Services</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  Our service may integrate with third-party gift card issuers and payment processors. We are not responsible for:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>The availability or accuracy of third-party services.</li>
                  <li>Any issues arising from your relationship with gift card issuers.</li>
                  <li>The content or practices of linked third-party websites.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">7. Account Termination</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  We reserve the right to suspend or terminate your access to our service at any time, without notice, for:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Violation of these Terms of Service.</li>
                  <li>Fraudulent or illegal activities.</li>
                  <li>Abuse of the service or other users.</li>
                  <li>Any reason we deem necessary to protect our service and users.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">8. Disclaimer of Warranties</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  We do not warrant that:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>The service will meet your specific requirements or expectations.</li>
                  <li>The service will be available at all times or without interruption.</li>
                  <li>The results obtained from using the service will be accurate or reliable.</li>
                  <li>Any errors or defects in the service will be corrected.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">9. Indemnification</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  You agree to indemnify and hold harmless My Gift Info and its affiliates from any claims, damages, losses, liabilities, and expenses (including legal fees) arising from:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Your use or misuse of the service.</li>
                  <li>Your violation of these Terms of Service.</li>
                  <li>Your violation of any rights of third parties.</li>
                  <li>Any fraudulent or illegal activities conducted through your use of the service.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">10. Changes to Terms</h2>
                <p className="text-muted-foreground leading-relaxed">
                  We reserve the right to modify these Terms of Service at any time. We will notify users of significant changes by posting the updated terms on our website with a new effective date. Your continued use of the service after changes constitutes acceptance of the modified terms.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">11. Governing Law</h2>
                <p className="text-muted-foreground leading-relaxed">
                  These Terms of Service shall be governed by and construed in accordance with applicable laws. Any disputes arising from these terms shall be resolved in the appropriate courts.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">12. Contact Information</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  If you have any questions or concerns about these Terms of Service, please contact us:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Email: support@mygiftinfo.com</li>
                  <li>Address: Legal Department</li>
                </ul>
              </section>

              <div className="bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-950/30 dark:to-blue-900/20 border-l-4 border-primary p-5 rounded-lg mt-8">
                <p className="text-foreground leading-relaxed">
                  <strong>Effective Date:</strong> These Terms of Service are effective as of October 2025 and govern your use of My Gift Info services.
                </p>
              </div>
            </CardContent>
          </Card>
        </div>
      </main>
    </div>
  );
}
